#!/usr/bin/perl

# This requires the typemap from perl 5.8.0
use Inline "C";

print "Using array ref, sum = ", sum_as_ref([1..10]),"\n";
print "Using list,      sum = ", sum_as_list(1..10),"\n";


__END__
__C__

int sum_as_ref(AV* avref)
{
  int len;
  int i;
  int sum = 0;
  SV ** elem;

  len = av_len(avref) + 1;

  for (i=0; i<len; i++) {
    elem = av_fetch(avref, i, 0);
    if (elem != NULL)
       sum += SvIV( *elem );
  }
  return sum;
}

int sum_as_list( SV* arg1, ... )
{
  int i;
  int len;
  int sum = 0;
  SV* elem;
  Inline_Stack_Vars;

  len = Inline_Stack_Items;
  for (i=0; i<len; i++) {
    elem = Inline_Stack_Item(i);
    sum += SvIV( elem );
  }
  return sum;
}
