#!/usr/bin/perl
use Inline "C";
use Data::Dumper;


my %time = gmtime_as_list( time );
print Dumper(\%time);

__END__
__C__

void gmtime_as_list( time_t clock )
{
  struct tm * tmbuf;
  Inline_Stack_Vars;
  Inline_Stack_Reset;

  tmbuf = gmtime( &clock );

  Inline_Stack_Push( sv_2mortal( newSVpv("sec", 3) ));
  Inline_Stack_Push( sv_2mortal( newSViv(tmbuf->tm_sec) ));
  Inline_Stack_Push( sv_2mortal( newSVpv("min", 3) ));
  Inline_Stack_Push( sv_2mortal( newSViv(tmbuf->tm_min) ));
  Inline_Stack_Push( sv_2mortal( newSVpv("hour", 4) ));
  Inline_Stack_Push( sv_2mortal( newSViv(tmbuf->tm_hour) ));
  Inline_Stack_Push( sv_2mortal( newSVpv("mday", 4) ));
  Inline_Stack_Push( sv_2mortal( newSViv(tmbuf->tm_mday) ));
  Inline_Stack_Push( sv_2mortal( newSVpv("mon", 3) ));
  Inline_Stack_Push( sv_2mortal( newSViv(tmbuf->tm_mon) ));
  Inline_Stack_Push( sv_2mortal( newSVpv("year", 4) ));
  Inline_Stack_Push( sv_2mortal( newSViv(tmbuf->tm_year) ));
  Inline_Stack_Push( sv_2mortal( newSVpv("wday", 4) ));
  Inline_Stack_Push( sv_2mortal( newSViv(tmbuf->tm_wday) ));
  Inline_Stack_Push( sv_2mortal( newSVpv("yday", 4) ));
  Inline_Stack_Push( sv_2mortal( newSViv(tmbuf->tm_yday) ));

  Inline_Stack_Done;
}
