use Test;
BEGIN { plan tests => 9 }

use FPGPLOT;

# open color postscript file pgplot.ps
my $ret = FPGPLOT::pgbeg( 1, "/cps",1,1);
ok( $ret, 1);

# Set color index 
my $col = 52;
my $rin = 0.5;
my $gin = 0.5;
my $bin = 0.0;

FPGPLOT::pgscr($col, $rin,$gin,$bin);
ok(3);

# and query it
FPGPLOT::pgqcr($col, my $r, my $g, my $b);
ok($r,$rin);
ok($g,$gin);
ok($b,$bin);

# Query the device
FPGPLOT::pgqinf('STATE',my $out, my $length);
ok($length, 4);
ok($out, "OPEN");

FPGPLOT::pgqinf('HARDCOPY',$out, $length);
ok($out, "YES");

# close the device
FPGPLOT::pgend();
ok(1);


unlink "pgplot.ps";
