
# Test Coordinate class
use Test;
BEGIN { plan tests => 6 }

# You can test either the Perl module or the C++ module
# simply by switching the use statement between
#  use PerlCoordinate;
# and
#  use Coordinate;
# The module names are different but the package names are the same

# By default we test the C++ interface
use Coordinate;

$c = new Coordinate();
print "# C is $c\n";

ok( $c->getX(), 0);
ok( $c->getY(), 0);

$d = $c->distance( 3, 4 );
ok( $d, 5);

$c2 = new Coordinate();
$c2->setX( 3 );
$c2->setY( 4 );

# Distance from other object
$d = $c->distance( $c2 );
ok( $d, 5 );

# Constructor using other object
$c3 = new Coordinate( $c2 );
$c3 = new Coordinate( $c2->getX, $c2->getY );

ok( $c3->getX, $c2->getX);
ok( $c3->getY, $c2->getY);

