package Coordinate;

sub new {
  my $proto = shift;
  my $class = ref($proto) || $proto;

  my ($x, $y) = (0,0);
  if (scalar(@_) == 1) {
    $x = $_[0]->getX;
    $y = $_[0]->getY;
  } elsif (scalar(@_) == 2) {
    $x = shift;
    $y = shift;
  }
  return bless { _x => $x, _y => $y }, $class;
}

sub setX { $_[0]->{_x} = $_[1] };
sub setY { $_[0]->{_y} = $_[1] };
sub getX { $_[0]->{_x} };
sub getY { $_[0]->{_y} };

sub distance {
  my ($self, $x, $y) = @_;
  if (UNIVERSAL::isa($x, "Coordinate")) {
    $y = $x->getX;
    $x = $x->getY;
  }
  my $xdiff = $x - $self->getX;
  my $ydiff = $y - $self->getY;
  my $sumsq = ($xdiff * $xdiff) + ($ydiff*$ydiff);
  return int( sqrt( $sumsq ) );
}

1;
