// Test C++ module

#ifdef __cplusplus
extern "C" {
#endif
#include "EXTERN.h"   /* std perl include */
#include "perl.h"     /* std perl include */
#include "XSUB.h"     /* XSUB include */
#ifdef __cplusplus
}
#endif

#include <stdio.h>
#include <iostream.h>
#include <stdlib.h>


 class Coordinate {
    int _x, _y;
 
  public:
    Coordinate() {
      _x = _y = 0;
    }
    Coordinate(const int xval, const int yval) {
      _x = xval;
      _y = yval;
    }
    Coordinate(const Coordinate &from) {
      _x = from._x;
      _y = from._y;
    }

    void setX(const int val);
    void setY(const int val);
    int getX() { return _x; }
    int getY() { return _y; }

    int distance( const Coordinate &from);
    int distance( const int x, const int y);

  };

 void Coordinate::setX(const int val) {
    _x = val;
 }

 void Coordinate::setY(const int val) {
    _y = val;
 }

 int Coordinate::distance( const int x, const int y) {
   int xdiff, ydiff, sumsq;

   xdiff = x - _x;
   ydiff = y - _y;
   sumsq = (xdiff * xdiff) + (ydiff * ydiff);

   return int( sqrt( sumsq ));
 }

 int Coordinate::distance( const Coordinate &from ) {
  return this->distance( from._x, from._y );
 }


MODULE = Coordinate  PACKAGE = Coordinate


Coordinate *
Coordinate::new( ... )
 PREINIT:
  int x;
  int y;
  Coordinate * from;
 CODE:
  if (items == 1) {
    RETVAL = new Coordinate();
  } else if (items == 2) {
    if (sv_derived_from(ST(1), "CoordinatePtr")) {
        IV tmp = SvIV((SV*)SvRV(ST(1)));
        from = INT2PTR(Coordinate *,tmp);
    }
    else
        croak("from is not of type CoordinatePtr");
    RETVAL = new Coordinate( *from );
  } else if (items == 3) {
    x = (int)SvIV(ST(1));
    y = (int)SvIV(ST(2));
    RETVAL = new Coordinate(x, y );
  } else {
    croak("Too many arguments to distance");
  }
 OUTPUT:
  RETVAL


MODULE = Coordinate PACKAGE = CoordinatePtr

int
Coordinate::getX()

int
Coordinate::getY()

void
Coordinate::setY( y )
  int y

void
Coordinate::setX( x )
  int x

int
Coordinate::distance( ... )
 PREINIT:
  int x;
  int y;
  Coordinate * from;
 CODE:
  if (items == 2) {
    if (sv_derived_from(ST(1), "CoordinatePtr")) {
        IV tmp = SvIV((SV*)SvRV(ST(1)));
        from = INT2PTR(Coordinate *,tmp);
    }
    else
        croak("from is not of type CoordinatePtr");
    RETVAL = THIS->distance( *from );
  } else if (items == 3) {
    x = (int)SvIV(ST(1));
    y = (int)SvIV(ST(2));
    RETVAL = THIS->distance(x, y );
  } else {
    croak("Too many arguments to distance");
  }
 OUTPUT:
  RETVAL

