#!perl

use strict;
use Test;
BEGIN { plan tests => 13 }
use CallBack;

ok(1);

my @unsorted = (4,6,2,-1,5);

my @reference = sort { $a <=> $b } @unsorted;

# first all in one go
my @immcall = CallBack::qsorti { $_[0] <=> $_[1] } @unsorted;

cmparr(\@immcall, \@reference);

# Deferred callback
# Register
CallBack::register_qsort_cb( sub { $_[0] <=> $_[1] } );

# and sort
my @defcall = CallBack::qsorti_cb(@unsorted);
cmparr(\@defcall, \@reference);

# Compare two arrays
sub cmparr {
  my ($out, $exp) = @_;

  ok(scalar(@$out), scalar(@$exp));

  for my $i (0..$#$out) {
    ok($out->[$i], $exp->[$i]);
  }

}
