#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

typedef int intArray;

/* This allows us to provide an explicit typemap rather than
   relying on the T_CVREF entry which is broken in perl
   prior to perl 5.8.0. If you are using 5.8.0 you can just
   return a CV* */
typedef CV CVPROTO;

/* Static memory for qsort callback */
static SV * qsortsv = (SV*)NULL;


/* Routine to allocate memory for integer array */
/* Allocate the memory as a mortal SV so that it is freed automatically */
intArray * intArrayPtr ( int num ) {
  SV * mortal;
  mortal = sv_2mortal( NEWSV(0, num * sizeof(intArray) ) );
  return (intArray *)SvPVX(mortal);
}

/* The callback for qsort */
int qsorti_cb( const void *a, const void *b) {

  dSP;
  int count;
  int answer;

  ENTER;
  SAVETMPS;
  PUSHMARK(SP);

  /* Push some SVs onto the stack with the values of a and b */
  XPUSHs(sv_2mortal(newSViv(*(int *)a)));
  XPUSHs(sv_2mortal(newSViv(*(int *)b)));

  PUTBACK;

  count = call_sv(qsortsv, G_SCALAR );

  SPAGAIN;

  if (count != 1)
      croak("User defined qsort callback returned more than 1 value\n");

  answer = POPi;

  FREETMPS;
  LEAVE;

  return answer;
}

MODULE = CallBack		PACKAGE = CallBack		

void
qsorti(cb, array, ...)
  SV * cb
  intArray * array
 PREINIT:
  U32 i;
 PROTOTYPE: &@
 PPCODE:
  qsortsv = cb;

  qsort( array, ix_array, sizeof(int), qsorti_cb);

  /* now need to push the elements back onto the stack */
  for ( i =0; i < ix_array; i++) {
    XPUSHs(sv_2mortal(newSViv(array[i])));
  }

  /* Since this routine is sharing the callback with the
     deferred callback example we must clear variable
     qsortsv when we have finished with it. Note that
     this implies that you can not run this routine
     after you have registered a callback using register_qsort_cb
     else that callback will be lost  */
  qsortsv = NULL;

void
register_qsort_cb( cb )
  SV * cb
 CODE:
  if (qsortsv == (SV*)NULL) {
      /* This is first time in so create an SV */
      qsortsv = newSVsv(cb) ;
  } else {
      /* overwrite since we have already stored something */
      SvSetSV(qsortsv, cb) ;
  }

void
qsorti_cb(array, ...)
  intArray * array
 PREINIT:
  U32 i;
 PPCODE:
  /* Trap the case where we have not registered a callback, or we 
     have called qsorti after registering a callback */
  if (qsortsv == (SV*)NULL)
      croak("You are attempting to sort an array without registering a callback!\n");

  qsort( array, ix_array, sizeof(int), qsorti_cb);

  /* now need to push the elements back onto the stack */
  for ( i =0; i < ix_array; i++) {
    XPUSHs(sv_2mortal(newSViv(array[i])));
  }

