
use Test;
BEGIN { plan tests => 14 }
use Arrays;
ok(1);


my @input = (1..10);

# calculate the reference sum
my $sum;
for (@input) { $sum += $_ }

ok(Arrays::sum_as_list(@input),$sum);
ok(Arrays::sum_as_ref(\@input),$sum);

my $packed_array = pack("i*",@input);
ok(Arrays::sum_as_packed($packed_array), $sum);
ok(Arrays::sum_as_packed2(scalar(@input),$packed_array), $sum);

my @ret = Arrays::test_t_array();
ok(scalar(@ret), 2);
ok($ret[0],1);
ok($ret[1],2);

my $packed = Arrays::return_packed();
my @packed = unpack("i*",$packed);
ok($packed[0], 1);
ok($packed[1], 2);
ok($packed[2], 3);

$packed = Arrays::return_npacked();
@packed = unpack("i*",$packed);
ok($packed[0], 1);
ok($packed[1], 2);
ok($packed[2], 3);
