
use Test;
BEGIN { plan tests => 12 }
use Arrays;
ok(1);


# Environ is not in the book but is included
# as an additional example
my @env = Arrays::environ;

# Generate environment hash
my %env;
for my $entry (@env) {
  my ($key,$val) = split('=',$entry);
  $env{$key} = $val;
}

ok($env{HOME},$ENV{HOME});


# Copy array using the reference natively
my @input = qw/ red green blue /;
my @output = Arrays::copy_char_arr_ref(\@input);

ok(scalar(@output), scalar(@input));
for my $i (0..scalar(@input)) {
  ok($output[$i],$input[$i]);
}

# Copy array using the char** typemap entry
my $ref = Arrays::copy_char_arr_ptr(\@input);
@output = @$ref;

ok(scalar(@output), scalar(@input));
for my $i (0..scalar(@input)) {
  ok($output[$i],$input[$i]);
}
