
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

/* Generic mortal allocator */
void * get_mortalspace ( int nbytes ) {
  SV * mortal;
  mortal = sv_2mortal( NEWSV(2040, nbytes ) );
  return (void *) SvPVX( mortal );
}

/* These helper routines are for copy_char_arr
   using T_PACKEDARRAY. Page 201 */

char ** XS_unpack_charPtrPtr( SV * arg ) {
  AV * avref;
  char ** array;
  int len;
  SV ** elem;
  int i;

  avref = (AV*)SvRV(arg);
  len = av_len( avref ) + 1;

  /* First allocate some memory for the pointers 
     plus one for the end */
  array = get_mortalspace( (len+1) * sizeof( *array ));   

  /* Loop over each element copying pointers to the array */
  for (i=0; i<len; i++) {
    elem = av_fetch( avref, i, 0);
    array[i] = SvPV_nolen( *elem );
  }
  /* add a null */
  array[len] = NULL;

  return array;
}

void XS_pack_charPtrPtr( SV * arg, char ** array, int count) {
  int i;
  AV * avref;

  avref  = (AV*)sv_2mortal((SV*)newAV());
  for (i=0; i<count; i++) {
    av_push(avref, newSVpv(array[i], strlen(array[i])));
  }
  SvSetSV( arg, newRV((SV*)avref));
}


MODULE = Arrays		PACKAGE = Arrays

void
copy_char_arr_ref( avref )
   AV * avref;
  PREINIT:
   char ** array;
   int len;
   SV ** elem;
   int i;
  PPCODE:
   len = av_len( avref ) + 1;
   /* First allocate some memory for the pointers */
   array = get_mortalspace( len * sizeof( *array ));

   /* Loop over each element copying pointers to the new array */
   for (i=0; i<len; i++) {
     elem = av_fetch( avref, i, 0);
     array[i] = SvPV( *elem, PL_na );
   }

   /* Now copy it back onto the stack */
   for (i=0; i<len; i++) { 
     XPUSHs( sv_2mortal( newSVpv( array[i], 0)));
   }



void
environ()
  PREINIT:
    char ** e;
    int i = 0;
  PPCODE:
    for (e = environ; *e; e++) {
      XPUSHs(sv_2mortal(newSVpv(*e,PL_na)));
    }


char **
copy_char_arr_ptr( array )
  char ** array
 PREINIT:
  int count_charPtrPtr;
  int i;
 CODE:
  RETVAL = array;
  /* decide how many elements to return */
  i = 0;
  while ( array[i] != NULL ) {
    i++;
  }
  /* loop exits with count */
  count_charPtrPtr = i;
 OUTPUT:
  RETVAL
