#ifdef __cplusplus
extern "C" {
#endif
#include "EXTERN.h"   /* std perl include */
#include "perl.h"     /* std perl include */
#include "XSUB.h"     /* XSUB include */
#ifdef __cplusplus
}
#endif

/* Add up everything in an int array */
/* Args: the number of things to add, pointer to array */

int sum ( int num, int * array ) {
  int thesum = 0;
  int count;
  for (count = 0; count < num; count++) {
    /* printf("%d Adding... %d to %d\n", count,array[count],thesum);*/
    thesum += array[count];
  }
  return thesum;
}


/* PDL include files */
#include "pdl.h"
#include "pdlcore.h"

static Core * PDL; 
SV* CoreSV;       

MODULE = PDLsum  PACKAGE = PDLsum

BOOT:
   /* Get pointer to structure of core shared C routines */
   CoreSV = perl_get_sv("PDL::SHARE",FALSE);  /* SV* value */
   if (CoreSV==NULL)
     Perl_croak(aTHX_ "This module requires use of PDL::Core first");
   PDL = INT2PTR(Core*, SvIV( CoreSV ));  /* Core* value */

int
sum_as_pdl( in )
  pdl * in
 CODE:
  PDL->converttype( &in, PDL_L, 1);
  RETVAL = sum( in->nvals, (int *)in->data);
 OUTPUT:
  RETVAL
