use ExtUtils::MakeMaker;
use Config;
use File::Spec;
use strict;

my $pdlroot = File::Spec->catdir($Config{'installsitearch'},
                                "PDL", "Core");

my $pdltypemap = File::Spec->catfile($pdlroot, "typemap.pdl");

# Write the makefile
WriteMakefile(
	      'NAME'=> 'PDLsum',
	      'VERSION_FROM' => 'PDLsum.pm', # finds $VERSION
	      'PREREQ_PM' => { 'PDL' => '2.0'},
	      'LIBS'      =>  [  ],
	      'INC'       => "-I$pdlroot",
	      'TYPEMAPS'  => [ $pdltypemap ],
	      'dist'      => { COMPRESS => "gzip -9f" },
	     );


