use strict;
use 5.008;
use Test;
BEGIN { plan tests => 14 }
use Time;

ok(1);

# pick a unix epoch  2002-09-26T21:13:54
my $epoch = 1033074834;

# First use the simple interface
my $t = Time::gmtime( $epoch );
_testTime( $t );

# Now the var arg version
# ... with no args
$t = Time::gmtime_vararg();

# Test by translating back to time_t and making sure we
# are more recent than the reference time
ok( Time::timegm( $t)  > $epoch );

# ...and with reference epoch
$t = Time::gmtime_vararg( $epoch );
_testTime( $t );

# reentrant version
$t = Time::gmtime_r( $epoch );
_testTime( $t );

# buffer copy
$t = Time::gmtime_cp( $epoch );
_testTime( $t );

# OO implementation
print "# OO implementation\n";
$t = new Time( $epoch );

ok( $t->timegm, $epoch );
ok( $t->strftime( "%Y%m%d" ), "20020926");


print "# Return Hashref\n";

my $h = Time::gmtime_as_href( $epoch );
ok( $h->{year}, 102 );
ok( $h->{mday}, 26 );
ok( $h->{mon}, 8 );

print "# Return list\n";
my %l = Time::gmtime_as_list( $epoch );
ok( $l{year}, 102 );
ok( $l{mday}, 26 );
ok( $l{mon}, 8 );

exit;

sub _testTime {
  my $test = shift;
  ok(Time::strftime($test,"%Y%m%d"), "20020926");
}
