#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

/* Backwards compatibility macros */
#include "ppport.h"

/* We need a Time* for OO method */
typedef struct tm Time;

MODULE = Time		PACKAGE = Time		

struct tm *
gmtime( clock )
  time_t &clock



struct tm *
gmtime_vararg( ... )
 PREINIT:
  time_t clock;
 CODE:
  if (items > 1)
     Perl_croak(aTHX_ "Usage: Time::gmtime( [time] )");
  else if (items == 1)
     clock = (time_t)SvNV(ST(0));
  else
     clock = time( NULL );

  RETVAL = gmtime( &clock );
 OUTPUT:
  RETVAL



struct tm *
gmtime_r( clock );
  time_t clock;
 PREINIT:
  struct tm * tmbuf;
 CODE:
  New( 0, tmbuf, 1, struct tm );
  RETVAL = gmtime_r( &clock, tmbuf );
 OUTPUT:
  RETVAL

struct tm *
gmtime_cp( clock );
  time_t clock;
 PREINIT:
  struct tm * tmbuf;
  struct tm * result;
 CODE:
  result = gmtime( &clock );
  New( 0, tmbuf, 1, struct tm );
  StructCopy( result, tmbuf, struct tm);
  RETVAL = tmbuf;
 OUTPUT:
  RETVAL


Time *
new( class, ... );
  char * class
 PREINIT:
  time_t clock;
  Time * tmbuf;
  Time * result;
 CODE:
  if (items > 2)
     Perl_croak(aTHX_ "Usage: new Time( [time] )");
  else if (items == 2)
     clock = (time_t)SvNV(ST(1));
  else
     clock = time( NULL );

  result = gmtime( &clock );
  New( 0, tmbuf, 1, Time );
  StructCopy( result, tmbuf, struct tm);
  RETVAL = tmbuf;
 OUTPUT:
  RETVAL

time_t
timegm( tm )
  struct tm * tm

char *
strftime( tm, format )
  struct tm * tm
  char * format
 PREINIT:
  char tmpbuf[128];
  size_t len;
 CODE:
  len = strftime( tmpbuf, sizeof(tmpbuf), format, tm);
  if (len > 0 && len < sizeof(tmpbuf)) {
     RETVAL = tmpbuf;
  } else {
     XSRETURN_UNDEF;
  }
 OUTPUT:
  RETVAL


HV *
gmtime_as_href( clock )
  time_t clock
 PREINIT:
  HV * hash;
  struct tm * tmbuf;
 CODE:
  /* Run gmtime */
  tmbuf = gmtime( &clock );

  hash = (HV*)sv_2mortal((SV*)newHV());

  /* Copy struct contents into hash */
  hv_store(hash, "sec",  3, newSViv(tmbuf->tm_sec), 0);
  hv_store(hash, "min",  3, newSViv(tmbuf->tm_min), 0);
  hv_store(hash, "hour", 4, newSViv(tmbuf->tm_hour), 0);
  hv_store(hash, "mday", 4, newSViv(tmbuf->tm_mday), 0);
  hv_store(hash, "mon",  3, newSViv(tmbuf->tm_mon), 0);
  hv_store(hash, "year", 4, newSViv(tmbuf->tm_year), 0);
  hv_store(hash, "wday", 4, newSViv(tmbuf->tm_wday), 0);
  hv_store(hash, "yday", 4, newSViv(tmbuf->tm_yday), 0);

  RETVAL = hash;
OUTPUT:
  RETVAL

void
gmtime_as_list( clock )
  time_t clock
 PREINIT:
  struct tm * tmbuf;
 PPCODE:
  tmbuf = gmtime( &clock );

  EXTEND(SP, 16);

  PUSHs( sv_2mortal( newSVpv("sec", 3) ));
  PUSHs( sv_2mortal( newSViv(tmbuf->tm_sec) ));
  PUSHs( sv_2mortal( newSVpv("min", 3) ));
  PUSHs( sv_2mortal( newSViv(tmbuf->tm_min) ));
  PUSHs( sv_2mortal( newSVpv("hour", 4) ));
  PUSHs( sv_2mortal( newSViv(tmbuf->tm_hour) ));
  PUSHs( sv_2mortal( newSVpv("mday", 4) ));
  PUSHs( sv_2mortal( newSViv(tmbuf->tm_mday) ));
  PUSHs( sv_2mortal( newSVpv("mon", 3) ));
  PUSHs( sv_2mortal( newSViv(tmbuf->tm_mon) ));
  PUSHs( sv_2mortal( newSVpv("year", 4) ));
  PUSHs( sv_2mortal( newSViv(tmbuf->tm_year) ));
  PUSHs( sv_2mortal( newSVpv("wday", 4) ));
  PUSHs( sv_2mortal( newSViv(tmbuf->tm_wday) ));
  PUSHs( sv_2mortal( newSVpv("yday", 4) ));
  PUSHs( sv_2mortal( newSViv(tmbuf->tm_yday) ));


MODULE = Time    PACKAGE = TimePtr

time_t
timegm( tm )
  Time * tm

char *
strftime( tm, format )
  Time * tm
  char * format
 PREINIT:
  char tmpbuf[128];
  size_t len;
 CODE:
  len = strftime( tmpbuf, sizeof(tmpbuf), format, tm);
  if (len > 0 && len < sizeof(tmpbuf)) {
     RETVAL = tmpbuf;
  } else {
     XSRETURN_UNDEF;
  }
 OUTPUT:
  RETVAL

void
DESTROY( tm )
  Time * tm
 CODE:
  Safefree( tm );
