use strict;
use Test;
BEGIN { plan tests => 3 }
use ReadLine;

# Test our simple readline interface. The only function
# implemented retrieves a character from an input buffer.
# we test this by reading from a file

# only get this if we loaded
ok(1);

# Open a file
my $tmpfile = "tmpfile.txt";
open my $fh, ">$tmpfile"
  or die "Error opening temp file: $!";

# write a character
my $char = "X";
print $fh $char;

# close the file
close $fh or die "Error closing temp file: $!";

# reopen it
open $fh, "< $tmpfile"
   or die "Error re-opening tempfile: $!";

# Read the first character [note that we have no prefix]
my $int = ReadLine::getc( $fh );
ok($int); # got something

print "# Read character number $int from tempfile\n";

# Compare it with what we wrote
ok( $int, ord($char));

# Close file and remove it
close $fh or die "Error closing temp file: $!";
unlink $tmpfile or die "Error unlinking temp file: $!";
