#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#include <string.h>

/* this function acts as an external library call for
   the purposes of this example. It simply concatenates
   two strings */
STRLEN strconcat (char* str1, char* str2, char* outstr) {
   strcpy( outstr, (const char*)str1 );
   strcat( outstr, (const char*)str2 );
   return strlen( outstr );
}


MODULE = Example   PACKAGE = Example

STRLEN
strconcat( str1, str2, outstr )
  char* str1
  char* str2
  char* outstr = NO_INIT
 PREINIT:
  STRLEN length;
 CODE:
  length = strlen( str1 ) + strlen( str2 ) + 1;
  New(0, outstr, length, char );
  RETVAL = strconcat( str1, str2, outstr );
 OUTPUT:
  outstr
  RETVAL
 CLEANUP:
  Safefree( outstr );

char *
strconcat_retchar( str1, str2 )
  char* str1
  char* str2
 PREINIT:
  STRLEN length;
 CODE:
  length = strlen( str1 ) + strlen( str2 ) + 1;
  New(0, RETVAL, length, char );
  length = strconcat( str1, str2, RETVAL );
 OUTPUT:
  RETVAL
 CLEANUP:
  Safefree( RETVAL );


